### 50. Heroku

Heroku是另外一个流行的Paas平台。想要自定义Heroku的构建过程，你可以提供一个`Procfile`，它提供部署一个应用所需的指令。Heroku为Java应用分配一个端口，确保能够路由到外部URI。

你必须配置你的应用监听正确的端口。下面是用于我们的starter REST应用的Procfile：
```shell
web: java -Dserver.port=$PORT -jar target/demo-0.0.1-SNAPSHOT.jar
```
Spring Boot将`-D`参数作为属性，通过一个Spring的Environment实例访问。`server.port`配置属性适合于内嵌的Tomcat，Jetty或Undertow实例启用时使用。`$PORT`环境变量被分配给Heroku Paas使用。

Heroku默认使用Java 1.6。只要你的Maven或Gradle构建时使用相同的版本就没问题（Maven用户可以设置`java.version`属性）。如果你想使用JDK 1.7，在你的pom.xml和Procfile临近处创建一个system.properties文件。在该文件中添加以下设置：
```java
java.runtime.version=1.7
```
这就是你需要做的一切。对于Heroku部署来说，经常做的工作就是使用`git push`将代码推送到生产环境。
```shell
$ git push heroku master

Initializing repository, done.
Counting objects: 95, done.
Delta compression using up to 8 threads.
Compressing objects: 100% (78/78), done.
Writing objects: 100% (95/95), 8.66 MiB | 606.00 KiB/s, done.
Total 95 (delta 31), reused 0 (delta 0)

-----> Java app detected
-----> Installing OpenJDK 1.7... done
-----> Installing Maven 3.2.3... done
-----> Installing settings.xml... done
-----> executing /app/tmp/cache/.maven/bin/mvn -B
       -Duser.home=/tmp/build_0c35a5d2-a067-4abc-a232-14b1fb7a8229
       -Dmaven.repo.local=/app/tmp/cache/.m2/repository
       -s /app/tmp/cache/.m2/settings.xml -DskipTests=true clean install

       [INFO] Scanning for projects...
       Downloading: http://repo.spring.io/...
       Downloaded: http://repo.spring.io/... (818 B at 1.8 KB/sec)
        ....
       Downloaded: http://s3pository.heroku.com/jvm/... (152 KB at 595.3 KB/sec)
       [INFO] Installing /tmp/build_0c35a5d2-a067-4abc-a232-14b1fb7a8229/target/...
       [INFO] Installing /tmp/build_0c35a5d2-a067-4abc-a232-14b1fb7a8229/pom.xml ...
       [INFO] ------------------------------------------------------------------------
       [INFO] BUILD SUCCESS
       [INFO] ------------------------------------------------------------------------
       [INFO] Total time: 59.358s
       [INFO] Finished at: Fri Mar 07 07:28:25 UTC 2014
       [INFO] Final Memory: 20M/493M
       [INFO] ------------------------------------------------------------------------

-----> Discovering process types
       Procfile declares types -> web

-----> Compressing... done, 70.4MB
-----> Launching... done, v6
       http://agile-sierra-1405.herokuapp.com/ deployed to Heroku

To git@heroku.com:agile-sierra-1405.git
 * [new branch]      master -> master

```
现在你的应用已经启动并运行在Heroku。
